data_element create variable  &
   variable_name = .Flap_Mechanism.FlapForceOut  &
   initial_condition = 0.0  &
   function = "0"
!
data_element create variable  &
   variable_name = .Flap_Mechanism.FlapForceIn  &
   initial_condition = 0.0  &
   function = "0"
!
data_element create variable  &
   variable_name = .Flap_Mechanism.FlapActOutPos  &
   initial_condition = 0.0  &
   function = "DM(outside_drive_eye.iforce, outside_drive_motor.jforce)-0.28"

!
data_element create variable  &
   variable_name = .Flap_Mechanism.FlapActOutVel  &
   initial_condition = 0.0  &
   function = "VR(outside_drive_eye.iforce, outside_drive_motor.jforce)"
!
data_element create variable  &
   variable_name = .Flap_Mechanism.FlatInActPos  &
   initial_condition = 0.0  &
   function = "DM(inside_drive_eye.iforce, inside_drive_motor.jforce)-0.28"
!
data_element create variable  &
   variable_name = .Flap_Mechanism.FlatInActVel  &
   initial_condition = 0.0  &
   function = "VR(inside_drive_eye.iforce, inside_drive_motor.jforce)" 
 

force create direct single_component_force  &
   single_component_force_name = .Flap_Mechanism.FlapForceOutVec  &
   type_of_freedom = translational  &
   i_marker_name = .Flap_Mechanism.outside_drive_eye.iforce  &
   j_marker_name = .Flap_Mechanism.outside_drive_motor.jforce  &
   action_only = off  &
  function = "STEP(time, 0.5, -300.0, 0.6, 0.0)","+100*VZ(outside_drive_motor.ref, outside_drive_eye.ref,outside_drive_eye.ref,outside_drive_eye.ref)","-BISTOP(DZ(outside_drive_motor.ref, outside_drive_eye.ref,outside_drive_eye.ref),","VZ(outside_drive_motor.ref,outside_drive_eye.ref,outside_drive_eye.ref,outside_drive_eye.ref),","-0.385, -0.001, 1.0E7, 2.0, 1.0E5, 0.002) "  
  

!
force create direct single_component_force  &
   single_component_force_name = .Flap_Mechanism.FlapForceInVec  &
   type_of_freedom = translational  &
   i_marker_name = .Flap_Mechanism.inside_drive_eye.iforce  &
   j_marker_name = .Flap_Mechanism.inside_drive_motor.jforce  &
   action_only = off  &
  function = "STEP(time, 0.5, -300.0, 0.6, 0.0)","+100*VZ(inside_drive_motor.ref, inside_drive_eye.ref, inside_drive_eye.ref, inside_drive_eye.ref)","-BISTOP(DZ(inside_drive_motor.ref, inside_drive_eye.ref, inside_drive_eye.ref),","VZ(inside_drive_motor.ref, inside_drive_eye.ref, inside_drive_eye.ref, inside_drive_eye.ref),","-0.385, -0.001, 1.0E7, 2.0, 1.0E5, 0.002) " 
  
  
entity attributes entity_name=.Flap_Mechanism.MOT_OUT_ACT, .Flap_Mechanism.MOT_IN_ACT active=off depend=off
  
simulation script create  &
   sim_script_name = .Flap_Mechanism.SIM_DYN  &
   type = auto_select  &
   initial_static = no  &
   number_of_steps = 800  &
   end_time = 8.0
!
simulation script create  &
   sim_script_name = .Flap_Mechanism.SIM_DYN_FAILURE  &
   solver_commands = "! Insert ACF commands here:", "OUTPUT/NOSEPARATOR",  &
                     "SIMULATE/TRANSIENT, END=1.0, STEPS=100",  &
                     "DEACTIVATE/SFORCE, ID=1",  &
                     "SIMULATE/TRANSIENT, DURATION=7.0, STEPS=700"
  