if condition=(DB_EXISTS(".Flap_Mechanism"))
   model delete model_name = .Flap_Mechanism
end   
!
!-------------------------- Default Units for Model ---------------------------!
!
!
defaults units  &
   length = meter  &
   angle = deg  &
   force = newton  &
   mass = kg  &
   time = sec
!
defaults units  &
   coordinate_system_type = cartesian  &
   orientation_type = body313
!
!--------------------------- Model Specific Colors ----------------------------!
!
!
if condition = (! db_exists(".colors.DDM_41"))
!
color create  &
   color_name = .colors.DDM_41  &
   red_component = 0.823529  &
   blue_component = 1.0  &
   green_component = 0.823529
!
else 
!
color modify  &
   color_name = .colors.DDM_41  &
   red_component = 0.823529  &
   blue_component = 1.0  &
   green_component = 0.823529
!
end 
!
if condition = (! db_exists(".colors.DDM_43"))
!
color create  &
   color_name = .colors.DDM_43  &
   red_component = 0.823529  &
   blue_component = 1.0  &
   green_component = 0.823529
!
else 
!
color modify  &
   color_name = .colors.DDM_43  &
   red_component = 0.823529  &
   blue_component = 1.0  &
   green_component = 0.823529
!
end 
!
if condition = (! db_exists(".colors.DDM_54"))
!
color create  &
   color_name = .colors.DDM_54  &
   red_component = 0.501961  &
   blue_component = 1.0  &
   green_component = 0.0
!
else 
!
color modify  &
   color_name = .colors.DDM_54  &
   red_component = 0.501961  &
   blue_component = 1.0  &
   green_component = 0.0
!
end 
!
if condition = (! db_exists(".colors.DDM_55"))
!
color create  &
   color_name = .colors.DDM_55  &
   red_component = 0.823529  &
   blue_component = 1.0  &
   green_component = 0.823529
!
else 
!
color modify  &
   color_name = .colors.DDM_55  &
   red_component = 0.823529  &
   blue_component = 1.0  &
   green_component = 0.823529
!
end 
!
if condition = (! db_exists(".colors.DDM_56"))
!
color create  &
   color_name = .colors.DDM_56  &
   red_component = 0.501961  &
   blue_component = 1.0  &
   green_component = 0.0
!
else 
!
color modify  &
   color_name = .colors.DDM_56  &
   red_component = 0.501961  &
   blue_component = 1.0  &
   green_component = 0.0
!
end 
!
if condition = (! db_exists(".colors.DDM_57"))
!
color create  &
   color_name = .colors.DDM_57  &
   red_component = 0.823529  &
   blue_component = 1.0  &
   green_component = 0.823529
!
else 
!
color modify  &
   color_name = .colors.DDM_57  &
   red_component = 0.823529  &
   blue_component = 1.0  &
   green_component = 0.823529
!
end 
!
!------------------------ Default Attributes for Model ------------------------!
!
!
defaults attributes  &
   inheritance = bottom_up  &
   icon_visibility = on  &
   grid_visibility = off  &
   size_of_icons = 0.1  &
   spacing_for_grid = 0.6
!
!------------------------------ Adams/View Model ------------------------------!
!
!
model create  &
   model_name = Flap_Mechanism  &
   title = "ADAMS/View model name: model1"
!
model attributes  &
   model_name = .Flap_Mechanism  &
   size_of_icons = 0.1
!
view erase
!
!-------------------------------- Data storage --------------------------------!
!
!
data_element create matrix full  &
   matrix_name = .Flap_Mechanism.MATRIX_1  &
   adams_id = 54  &
   input_order = by_row  &
   row_count = 20  &
   column_count = 3  &
   values =  &
      0.0, 0.0, 0.0,  &
      3.87765065E-002, 0.0, 0.0,  &
      7.75509777E-002, 3.9729369714E-004, 0.0,  &
      0.1163193431, 1.1918394E-003, 0.0,  &
      0.1550775328, 2.3835537E-003, 0.0,  &
      0.1938214782, 3.9723114E-003, 0.0,  &
      0.232547112, 5.9579458E-003, 0.0,  &
      0.2712503689, 8.3402485E-003, 0.0,  &
      0.3099271858, 1.11189694E-002, 0.0,  &
      0.3485735026, 1.42938166E-002, 0.0,  &
      0.3871852623, 1.78644571E-002, 0.0,  &
      0.4257584114, 2.18305159E-002, 0.0,  &
      0.4642889007, 2.61915766E-002, 0.0,  &
      0.5027726854, 3.09471816E-002, 0.0,  &
      0.5412057253, 3.60968314E-002, 0.0,  &
      0.5795839861, 4.16399856E-002, 0.0,  &
      0.6179034388, 4.75760622E-002, 0.0,  &
      0.6561600606, 5.39044381E-002, 0.0,  &
      0.6943498356, 6.06244489E-002, 0.0,  &
      0.7324687546, 6.77353892E-002, 0.0  &
   units = "length"
!
data_element create matrix full  &
   matrix_name = .Flap_Mechanism.MATRIX_55  &
   adams_id = 60  &
   input_order = by_row  &
   row_count = 20  &
   column_count = 3  &
   values =  &
      0.0, 0.0, 0.0,  &
      3.87765065E-002, 0.0, 0.0,  &
      7.75509777E-002, 3.9729369714E-004, 0.0,  &
      0.1163193431, 1.1918394E-003, 0.0,  &
      0.1550775328, 2.3835537E-003, 0.0,  &
      0.1938214782, 3.9723114E-003, 0.0,  &
      0.232547112, 5.9579458E-003, 0.0,  &
      0.2712503689, 8.3402485E-003, 0.0,  &
      0.3099271858, 1.11189694E-002, 0.0,  &
      0.3485735026, 1.42938166E-002, 0.0,  &
      0.3871852623, 1.78644571E-002, 0.0,  &
      0.4257584114, 2.18305159E-002, 0.0,  &
      0.4642889007, 2.61915766E-002, 0.0,  &
      0.5027726854, 3.09471816E-002, 0.0,  &
      0.5412057253, 3.60968314E-002, 0.0,  &
      0.5795839861, 4.16399856E-002, 0.0,  &
      0.6179034388, 4.75760622E-002, 0.0,  &
      0.6561600606, 5.39044381E-002, 0.0,  &
      0.6943498356, 6.06244489E-002, 0.0,  &
      0.7324687546, 6.77353892E-002, 0.0  &
   units = "length"
!
data_element create matrix full  &
   matrix_name = .Flap_Mechanism.MATRIX_61  &
   adams_id = 87  &
   input_order = by_row  &
   row_count = 20  &
   column_count = 3  &
   values =  &
      0.0, 0.0, 0.0,  &
      2.81118562E-002, 0.0, 0.0,  &
      5.62219733E-002, 3.1269110742E-004, 0.0,  &
      8.43268733E-002, 9.3803463384E-004, 0.0,  &
      0.1124230788, 1.8759532E-003, 0.0,  &
      0.1405071137, 3.1263308E-003, 0.0,  &
      0.1685755031, 4.6890127E-003, 0.0,  &
      0.1966247742, 6.5638055E-003, 0.0,  &
      0.2246514566, 8.7504773E-003, 0.0,  &
      0.2526520825, 1.12487575E-002, 0.0,  &
      0.2806231876, 1.40583371E-002, 0.0,  &
      0.3085613111, 1.71788684E-002, 0.0,  &
      0.3364629962, 2.06099652E-002, 0.0,  &
      0.3643247908, 2.43512032E-002, 0.0,  &
      0.3921432475, 2.84021194E-002, 0.0,  &
      0.4199149246, 3.27622126E-002, 0.0,  &
      0.4476363858, 3.74309433E-002, 0.0,  &
      0.4753042013, 4.24077338E-002, 0.0,  &
      0.5029149478, 4.76919685E-002, 0.0,  &
      0.5304652091, 5.32829935E-002, 0.0  &
   units = "length"
!
data_element create matrix full  &
   matrix_name = .Flap_Mechanism.MATRIX_94  &
   adams_id = 96  &
   input_order = by_row  &
   row_count = 20  &
   column_count = 3  &
   values =  &
      0.0, 0.0, 0.0,  &
      2.81118562E-002, 0.0, 0.0,  &
      5.62219733E-002, 3.1269110742E-004, 0.0,  &
      8.43268733E-002, 9.3803463384E-004, 0.0,  &
      0.1124230788, 1.8759532E-003, 0.0,  &
      0.1405071137, 3.1263308E-003, 0.0,  &
      0.1685755031, 4.6890127E-003, 0.0,  &
      0.1966247742, 6.5638055E-003, 0.0,  &
      0.2246514566, 8.7504773E-003, 0.0,  &
      0.2526520825, 1.12487575E-002, 0.0,  &
      0.2806231876, 1.40583371E-002, 0.0,  &
      0.3085613111, 1.71788684E-002, 0.0,  &
      0.3364629962, 2.06099652E-002, 0.0,  &
      0.3643247908, 2.43512032E-002, 0.0,  &
      0.3921432475, 2.84021194E-002, 0.0,  &
      0.4199149246, 3.27622126E-002, 0.0,  &
      0.4476363858, 3.74309433E-002, 0.0,  &
      0.4753042013, 4.24077338E-002, 0.0,  &
      0.5029149478, 4.76919685E-002, 0.0,  &
      0.5304652091, 5.32829935E-002, 0.0  &
   units = "length"
!
data_element create curve  &
   curve_name = .Flap_Mechanism.CURVE_1  &
   adams_id = 55  &
   closed = no  &
   tension = 5.0E-002  &
   matrix_name = .Flap_Mechanism.MATRIX_1  &
   fit_type = curve_points  &
   interpolation_order = 4
!
data_element create curve  &
   curve_name = .Flap_Mechanism.CURVE_56  &
   adams_id = 61  &
   closed = no  &
   tension = 5.0E-002  &
   matrix_name = .Flap_Mechanism.MATRIX_55  &
   fit_type = curve_points  &
   interpolation_order = 4
!
data_element create curve  &
   curve_name = .Flap_Mechanism.CURVE_62  &
   adams_id = 88  &
   closed = no  &
   tension = 5.0E-002  &
   matrix_name = .Flap_Mechanism.MATRIX_61  &
   fit_type = curve_points  &
   interpolation_order = 4
!
data_element create curve  &
   curve_name = .Flap_Mechanism.CURVE_95  &
   adams_id = 97  &
   closed = no  &
   tension = 5.0E-002  &
   matrix_name = .Flap_Mechanism.MATRIX_94  &
   fit_type = curve_points  &
   interpolation_order = 4
!
!-------------------------------- Rigid Parts ---------------------------------!
!
! Create parts and their dependent markers and graphics
!
!---------------------------------- Airframe ----------------------------------!
!
!
! ****** Ground Part ******
!
part modify rigid_body name_and_position  &
   part_name = ground  &
   new_part_name = Airframe
!
defaults model  &
   part_name = Airframe
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.gra2_SHELL  &
   adams_id = 190  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.gra2_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.gra3_SHELL  &
   adams_id = 191  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.gra3_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.ref_inslif_ptcv  &
   adams_id = 56  &
   location = 11.45525407, -1.12395, 1.270000419  &
   orientation = 180.0d, 90.0d, 180.6227138d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.ref_inslif_ptcv  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.ref_outf_ptcv  &
   adams_id = 62  &
   location = 11.45525407, -3.6322, 1.270000419  &
   orientation = 180.0d, 90.0d, 180.6227138d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.ref_outf_ptcv  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.ref_in_bot_roller_ptcv  &
   adams_id = 89  &
   location = 11.58493086, -1.12395, 1.11785473  &
   orientation = 180.0d, 90.0d, 168.8237873d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.ref_in_bot_roller_ptcv  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.ref_inslir_ptcv  &
   adams_id = 92  &
   location = 11.45525407, -1.14935, 1.270000419  &
   orientation = 180.0d, 90.0d, 180.6227138d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.ref_inslir_ptcv  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.ref_outr_ptcv  &
   adams_id = 95  &
   location = 11.45525407, -3.6068, 1.270000419  &
   orientation = 180.0d, 90.0d, 180.6227138d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.ref_outr_ptcv  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.ref_out_bot_roller_ptcv  &
   adams_id = 98  &
   location = 11.58493086, -3.6322, 1.11785473  &
   orientation = 180.0d, 90.0d, 168.8237873d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.ref_out_bot_roller_ptcv  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.sph_in_motor  &
   adams_id = 153  &
   location = 11.4808, -1.704975, 1.23825  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.sph_in_motor  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.jsf1  &
   adams_id = 166  &
   location = 12.184126, -3.584575, 1.1568938  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.jsf1  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.jsf2  &
   adams_id = 167  &
   location = 12.184126, -3.101975, 1.1574272  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.jsf2  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.jsf3  &
   adams_id = 168  &
   location = 12.184126, -2.619375, 1.157986  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.jsf3  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.jsf4  &
   adams_id = 169  &
   location = 12.184126, -2.136775, 1.1585194  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.jsf4  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.jsf5  &
   adams_id = 170  &
   location = 12.184126, -1.654175, 1.1590782  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.jsf5  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.jsf6  &
   adams_id = 171  &
   location = 12.184126, -1.171575, 1.15951  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.jsf6  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.sph_out_motor  &
   adams_id = 185  &
   location = 11.4808, -3.051, 1.23825  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.sph_out_motor  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.gra4_SHELL  &
   adams_id = 192  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.gra4_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.gra5_SHELL  &
   adams_id = 193  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.gra5_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.gra6_SHELL  &
   adams_id = 194  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.gra6_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.gra7_SHELL  &
   adams_id = 195  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.gra7_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.gra1_SHELL  &
   adams_id = 220  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.gra1_SHELL  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.rev_spoiler  &
   adams_id = 222  &
   location = 11.460226, -1.14935, 1.302930846  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.rev_spoiler  &
   visibility = off
!
! ****** Floating Markers for current part ******
!
floating_marker create  &
   floating_marker_name = .Flap_Mechanism.Airframe.Float_inslif_ptcv  &
   adams_id = 58
!
floating_marker create  &
   floating_marker_name = .Flap_Mechanism.Airframe.float_outf_ptcv  &
   adams_id = 64
!
floating_marker create  &
   floating_marker_name = .Flap_Mechanism.Airframe.float_in_bot_roller_ptcv  &
   adams_id = 100
!
floating_marker create  &
   floating_marker_name = .Flap_Mechanism.Airframe.float_inslir_ptcv  &
   adams_id = 102
!
floating_marker create  &
   floating_marker_name = .Flap_Mechanism.Airframe.float_outr_ptcv  &
   adams_id = 104
!
floating_marker create  &
   floating_marker_name = .Flap_Mechanism.Airframe.float_out_bot_roller_ptcv  &
   adams_id = 106
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.Airframe.SHELL39  &
   reference_marker = .Flap_Mechanism.Airframe.gra2_SHELL  &
   file_name = "./cad/Airframe_39.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.Airframe.SHELL39  &
   color = RED  &
   visibility = on
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.Airframe.SHELL40  &
   reference_marker = .Flap_Mechanism.Airframe.gra3_SHELL  &
   file_name = "./cad/Airframe_40.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.Airframe.SHELL40  &
   color = RED  &
   visibility = on
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.Airframe.SHELL41  &
   reference_marker = .Flap_Mechanism.Airframe.gra4_SHELL  &
   file_name = "./cad/Airframe_41.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.Airframe.SHELL41  &
   color = DDM_41  &
   visibility = on
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.Airframe.SHELL42  &
   reference_marker = .Flap_Mechanism.Airframe.gra5_SHELL  &
   file_name = "./cad/Airframe_42.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.Airframe.SHELL42  &
   color = BLUE  &
   visibility = on
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.Airframe.SHELL43  &
   reference_marker = .Flap_Mechanism.Airframe.gra6_SHELL  &
   file_name = "./cad/Airframe_43.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.Airframe.SHELL43  &
   color = DDM_43  &
   visibility = on
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.Airframe.SHELL44  &
   reference_marker = .Flap_Mechanism.Airframe.gra7_SHELL  &
   file_name = "./cad/Airframe_44.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.Airframe.SHELL44  &
   color = BLUE  &
   visibility = on
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.Airframe.part1  &
   reference_marker = .Flap_Mechanism.Airframe.gra1_SHELL  &
   file_name = "./cad/Airframe.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.Airframe.part1  &
   color = SILVER  &
   visibility = off
!
geometry create curve bspline  &
   bspline_name = .Flap_Mechanism.Airframe.insli_curve  &
   ref_curve_name = .Flap_Mechanism.CURVE_1  &
   segment_count = 200  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_inslif_ptcv
!
geometry create curve bspline  &
   bspline_name = .Flap_Mechanism.Airframe.outsli_curve  &
   ref_curve_name = .Flap_Mechanism.CURVE_56  &
   segment_count = 200  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_outf_ptcv
!
geometry create curve bspline  &
   bspline_name = .Flap_Mechanism.Airframe.inbot_curve  &
   ref_curve_name = .Flap_Mechanism.CURVE_62  &
   segment_count = 200  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_in_bot_roller_ptcv
!
geometry create curve bspline  &
   bspline_name = .Flap_Mechanism.Airframe.outbot_curve  &
   ref_curve_name = .Flap_Mechanism.CURVE_95  &
   segment_count = 200  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_out_bot_roller_ptcv
!
part attributes  &
   part_name = .Flap_Mechanism.Airframe  &
   visibility = on  &
   size_of_icons = 0.1
!
!--------------------------- outside_bottom_roller ----------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.outside_bottom_roller  &
   adams_id = 2  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.outside_bottom_roller
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.outside_bottom_roller.cm  &
   adams_id = 3  &
   location = 11.5824, -3.616325, 1.1303  &
   orientation = 90.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_bottom_roller.cm  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_bottom_roller.iptcv  &
   adams_id = 83  &
   location = 11.58493086, -3.6322, 1.11785473  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_bottom_roller.iptcv  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_bottom_roller.fix_flap  &
   adams_id = 111  &
   location = 11.5824, -3.60045, 1.1303  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_bottom_roller.fix_flap  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_bottom_roller.gra_SHELL  &
   adams_id = 196  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_bottom_roller.gra_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.outside_bottom_roller  &
   mass = 1.608796247E-002  &
   center_of_mass_marker = .Flap_Mechanism.outside_bottom_roller.cm  &
   ixx = 1.2974137322E-006  &
   iyy = 2.0001795048E-006  &
   izz = 2.0001795048E-006  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.outside_bottom_roller.SHELL45  &
   reference_marker = .Flap_Mechanism.outside_bottom_roller.gra_SHELL  &
   file_name = "./cad/outside_bottom_roller.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.outside_bottom_roller.SHELL45  &
   color = YELLOW
!
part attributes  &
   part_name = .Flap_Mechanism.outside_bottom_roller  &
   size_of_icons = 0.1
!
!------------------------------- outside_slider -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.outside_slider  &
   adams_id = 14  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.outside_slider
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.outside_slider.ptcv_front  &
   adams_id = 59  &
   location = 11.47112857, -3.6322, 1.269875917  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_slider.ptcv_front  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_slider.graf_SHELL  &
   adams_id = 197  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_slider.graf_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_slider.cm  &
   adams_id = 15  &
   location = 11.6299452811, -3.5980610994, 1.2601725843  &
   orientation = 90.5728924891d, 98.3548666176d, 6.0532139837d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_slider.cm  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_slider.cyl_flap  &
   adams_id = 188  &
   location = 11.7602, -3.603625, 1.2192  &
   orientation = 180.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_slider.cyl_flap  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_slider.gra_SHELL  &
   adams_id = 198  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_slider.gra_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_slider.ptcv_rear  &
   adams_id = 84  &
   location = 11.72420758, -3.6068, 1.25888203  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_slider.ptcv_rear  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_slider.grar_SHELL  &
   adams_id = 199  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_slider.grar_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.outside_slider  &
   mass = 0.3141884872  &
   center_of_mass_marker = .Flap_Mechanism.outside_slider.cm  &
   ixx = 2.6935637889E-003  &
   iyy = 2.6064731318E-003  &
   izz = 1.3114327886E-004  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.outside_slider.SHELL48  &
   reference_marker = .Flap_Mechanism.outside_slider.gra_SHELL  &
   file_name = "./cad/outside_slider.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.outside_slider.SHELL48  &
   color = YELLOW
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.outside_slider.SHELL47  &
   reference_marker = .Flap_Mechanism.outside_slider.graf_SHELL  &
   file_name = "./cad/outside_slider_front_roller.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.outside_slider.SHELL47  &
   color = YELLOW
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.outside_slider.SHELL49  &
   reference_marker = .Flap_Mechanism.outside_slider.grar_SHELL  &
   file_name = "./cad/outside_slider_rear_roller.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.outside_slider.SHELL49  &
   color = YELLOW
!
part attributes  &
   part_name = .Flap_Mechanism.outside_slider  &
   size_of_icons = 0.1
!
!---------------------------- inside_bottom_roller ----------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.inside_bottom_roller  &
   adams_id = 22  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.inside_bottom_roller
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.inside_bottom_roller.cm  &
   adams_id = 23  &
   location = 11.5824, -1.139825, 1.1303  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_bottom_roller.cm  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_bottom_roller.tr_flap  &
   adams_id = 45  &
   location = 11.5824, -1.1557, 1.1303  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_bottom_roller.tr_flap  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_bottom_roller.iptcv  &
   adams_id = 85  &
   location = 11.58493086, -1.12395, 1.11785473  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_bottom_roller.iptcv  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_bottom_roller.gra_SHELL  &
   adams_id = 200  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_bottom_roller.gra_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.inside_bottom_roller  &
   mass = 1.608796247E-002  &
   center_of_mass_marker = .Flap_Mechanism.inside_bottom_roller.cm  &
   ixx = 1.2974137332E-006  &
   iyy = 2.0001795048E-006  &
   izz = 2.0001795048E-006  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.inside_bottom_roller.SHELL50  &
   reference_marker = .Flap_Mechanism.inside_bottom_roller.gra_SHELL  &
   file_name = "./cad/inside_bottom_roller.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.inside_bottom_roller.SHELL50  &
   color = YELLOW
!
part attributes  &
   part_name = .Flap_Mechanism.inside_bottom_roller  &
   size_of_icons = 0.1
!
!------------------------------- inside_slider --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.inside_slider  &
   adams_id = 28  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.inside_slider
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.inside_slider.ptcv_front  &
   adams_id = 53  &
   location = 11.47112857, -1.12395, 1.269875917  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_slider.ptcv_front  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_slider.graf_SHELL  &
   adams_id = 201  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_slider.graf_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_slider.cm  &
   adams_id = 29  &
   location = 11.6299388639, -1.1580884178, 1.2601667757  &
   orientation = 89.4271215254d, 98.3566144656d, 353.9403873146d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_slider.cm  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_slider.cyl_flap  &
   adams_id = 32  &
   location = 11.7602, -1.152525, 1.2192  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_slider.cyl_flap  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_slider.gra_SHELL  &
   adams_id = 202  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_slider.gra_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_slider.ptcv_rear  &
   adams_id = 86  &
   location = 11.72420758, -1.14935, 1.25888203  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_slider.ptcv_rear  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_slider.grar_SHELL  &
   adams_id = 203  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_slider.grar_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.inside_slider  &
   mass = 0.314124591  &
   center_of_mass_marker = .Flap_Mechanism.inside_slider.cm  &
   ixx = 2.6931540356E-003  &
   iyy = 2.6061305134E-003  &
   izz = 1.3107021338E-004  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.inside_slider.SHELL52  &
   reference_marker = .Flap_Mechanism.inside_slider.gra_SHELL  &
   file_name = "./cad/inside_slider.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.inside_slider.SHELL52  &
   color = YELLOW
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.inside_slider.SHELL51  &
   reference_marker = .Flap_Mechanism.inside_slider.graf_SHELL  &
   file_name = "./cad/inside_slider_front_roller.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.inside_slider.SHELL51  &
   color = YELLOW
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.inside_slider.SHELL53  &
   reference_marker = .Flap_Mechanism.inside_slider.grar_SHELL  &
   file_name = "./cad/inside_slider_rear_roller.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.inside_slider.SHELL53  &
   color = YELLOW
!
part attributes  &
   part_name = .Flap_Mechanism.inside_slider  &
   size_of_icons = 0.1
!
!---------------------------- outside_drive_motor -----------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.outside_drive_motor  &
   adams_id = 115  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.outside_drive_motor
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_motor.cm  &
   adams_id = 116  &
   location = 11.71360964, -3.051175, 1.222376615  &
   orientation = 180.0d, 90.0d, 183.9004937d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_motor.cm  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_motor.tr_eye  &
   adams_id = 140  &
   location = 11.7602, -3.051175, 1.2192  &
   orientation = 90.0d, 93.90049374d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_motor.tr_eye  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_motor.sph_airframe  &
   adams_id = 184  &
   location = 11.4808, -3.051, 1.23825  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_motor.sph_airframe  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_motor.gra_SHELL  &
   adams_id = 204  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_motor.gra_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_motor.jforce  &
   adams_id = 225  &
   location = 11.4808, -3.051, 1.23825  &
   orientation = 89.9641132423d, 93.9004929797d, 269.9975588434d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_motor.jforce  &
   visibility = on
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_motor.ref  &
   adams_id = 231  &
   location = 11.7602, -3.051175, 1.2192  &
   orientation = 89.9641132423d, 93.9004929797d, 269.9975588434d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_motor.ref  &
   visibility = on
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.outside_drive_motor  &
   mass = 1.3417624135  &
   center_of_mass_marker = .Flap_Mechanism.outside_drive_motor.cm  &
   ixx = 9.4936474808E-004  &
   iyy = 6.394713254E-002  &
   izz = 6.3947609402E-002  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.outside_drive_motor.SHELL54  &
   reference_marker = .Flap_Mechanism.outside_drive_motor.gra_SHELL  &
   file_name = "./cad/outside_drive_motor.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.outside_drive_motor.SHELL54  &
   color = DDM_54
!
part attributes  &
   part_name = .Flap_Mechanism.outside_drive_motor  &
   size_of_icons = 0.1
!
!----------------------------- outside_drive_eye ------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.outside_drive_eye  &
   adams_id = 119  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.outside_drive_eye
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_eye.cm  &
   adams_id = 120  &
   location = 11.7602, -3.051175, 1.2192  &
   orientation = 90.0d, 93.90009816d, 180.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_eye.cm  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_eye.tr_motor  &
   adams_id = 141  &
   location = 11.7602, -3.051175, 1.2192  &
   orientation = 90.0d, 93.90049374d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_eye.tr_motor  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_eye.uni_flap  &
   adams_id = 180  &
   location = 11.7602, -3.051175, 1.2192  &
   orientation = 270.0d, 89.67080993d, 90.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_eye.uni_flap  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_eye.gra_SHELL  &
   adams_id = 205  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_eye.gra_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_eye.iforce  &
   adams_id = 224  &
   location = 11.7602, -3.051175, 1.2192  &
   orientation = 89.9641132423d, 93.9004929797d, 269.9975588434d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_eye.iforce  &
   visibility = on
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_eye.ref  &
   adams_id = 230  &
   location = 11.7602, -3.051175, 1.2192  &
   orientation = 89.9641132423d, 93.9004929797d, 269.9975588434d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_eye.ref  &
   visibility = on
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.outside_drive_eye  &
   mass = 8.293433075E-002  &
   center_of_mass_marker = .Flap_Mechanism.outside_drive_eye.cm  &
   ixx = 2.8822753573E-005  &
   iyy = 5.8148617287E-005  &
   izz = 5.8748545314E-005  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.outside_drive_eye.SHELL55  &
   reference_marker = .Flap_Mechanism.outside_drive_eye.gra_SHELL  &
   file_name = "./cad/outside_drive_eye.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.outside_drive_eye.SHELL55  &
   color = DDM_55
!
part attributes  &
   part_name = .Flap_Mechanism.outside_drive_eye  &
   size_of_icons = 0.1
!
!----------------------------- inside_drive_motor -----------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.inside_drive_motor  &
   adams_id = 123  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.inside_drive_motor
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_motor.cm  &
   adams_id = 124  &
   location = 11.71360964, -1.704975, 1.222376615  &
   orientation = 180.0d, 89.99999988d, 183.9004937d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_motor.cm  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_motor.tr_eye  &
   adams_id = 142  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 90.0d, 93.90049374d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_motor.tr_eye  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_motor.sph_airframe  &
   adams_id = 151  &
   location = 11.4808, -1.704975, 1.23825  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_motor.sph_airframe  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_motor.gra_SHELL  &
   adams_id = 206  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_motor.gra_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_motor.jforce  &
   adams_id = 227  &
   location = 11.4808, -1.704975, 1.23825  &
   orientation = 90.0d, 93.9004937424d, 270.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_motor.jforce  &
   visibility = on
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_motor.ref  &
   adams_id = 229  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 90.0d, 93.9004937424d, 270.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_motor.ref  &
   visibility = on
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.inside_drive_motor  &
   mass = 1.3417624135  &
   center_of_mass_marker = .Flap_Mechanism.inside_drive_motor.cm  &
   ixx = 9.4936474808E-004  &
   iyy = 6.394713254E-002  &
   izz = 6.3947609402E-002  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.inside_drive_motor.SHELL56  &
   reference_marker = .Flap_Mechanism.inside_drive_motor.gra_SHELL  &
   file_name = "./cad/inside_drive_motor.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.inside_drive_motor.SHELL56  &
   color = DDM_56
!
part attributes  &
   part_name = .Flap_Mechanism.inside_drive_motor  &
   size_of_icons = 0.1
!
!------------------------------ inside_drive_eye ------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.inside_drive_eye  &
   adams_id = 127  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.inside_drive_eye
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_eye.cm  &
   adams_id = 128  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 90.0d, 93.90009808d, 180.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_eye.cm  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_eye.uni_flap  &
   adams_id = 129  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 90.0d, 90.0d, 270.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_eye.uni_flap  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_eye.tr_motor  &
   adams_id = 143  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 90.0d, 93.90049374d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_eye.tr_motor  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_eye.gra_SHELL  &
   adams_id = 207  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_eye.gra_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_eye.iforce  &
   adams_id = 226  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 90.0d, 93.9004937424d, 270.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_eye.iforce  &
   visibility = on
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_eye.ref  &
   adams_id = 228  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 90.0d, 93.9004937424d, 270.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_eye.ref  &
   visibility = on
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.inside_drive_eye  &
   mass = 8.293433075E-002  &
   center_of_mass_marker = .Flap_Mechanism.inside_drive_eye.cm  &
   ixx = 2.8822753568E-005  &
   iyy = 5.8148617287E-005  &
   izz = 5.8748545314E-005  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.inside_drive_eye.SHELL57  &
   reference_marker = .Flap_Mechanism.inside_drive_eye.gra_SHELL  &
   file_name = "./cad/inside_drive_eye.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.inside_drive_eye.SHELL57  &
   color = DDM_57
!
part attributes  &
   part_name = .Flap_Mechanism.inside_drive_eye  &
   size_of_icons = 0.1
!
!-------------------------------- Left_Spoiler --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.Left_Spoiler  &
   adams_id = 128  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Left_Spoiler
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.Left_Spoiler.PSMAR  &
   adams_id = 223  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Left_Spoiler.PSMAR  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Left_Spoiler.rev_airframe  &
   adams_id = 221  &
   location = 11.460226, -1.14935, 1.302930846  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Left_Spoiler.rev_airframe  &
   visibility = off
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.Left_Spoiler  &
   mass = 10.0  &
   center_of_mass_marker = .Flap_Mechanism.Left_Spoiler.rev_airframe  &
   ixx = 1.0  &
   iyy = 1.0  &
   izz = 1.0  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
part attributes  &
   part_name = .Flap_Mechanism.Left_Spoiler  &
   color = YELLOW
!
!--------------------------------- Rigid_flap ---------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.Rigid_flap  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Rigid_flap
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.gra  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Rigid_flap.gra  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.cm  &
   location = 12.0166125647, -2.3786868552, 1.1780506871  &
   orientation = 274.191697221d, 2.4985865457d, 85.7694819124d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Rigid_flap.cm  &
   color = RED
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.cyl_inslider  &
   location = 11.7602, -1.152525, 1.2192  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.tr_in_bot_rol  &
   location = 11.5824, -1.1557, 1.1303  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.uni_in_eye  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.fix_out_bot_rol  &
   location = 11.5824, -3.60045, 1.1303  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf1  &
   location = 12.184126, -3.584575, 1.1568938  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf1  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf2  &
   location = 12.184126, -3.101975, 1.1574272  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf2  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf3  &
   location = 12.184126, -2.619375, 1.157986  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf3  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf4  &
   location = 12.184126, -2.136775, 1.1585194  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf4  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf5  &
   location = 12.184126, -1.654175, 1.1590782  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf5  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf6  &
   location = 12.184126, -1.171575, 1.15951  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf6  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.uni_out_eye  &
   location = 11.7602, -3.051175, 1.2192  &
   orientation = 0.0d, 90.0d, 179.6708099d
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.cyl_outslider  &
   location = 11.7602, -3.603625, 1.2192  &
   orientation = 180.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.Rigid_flap  &
   mass = 58.0722748374  &
   center_of_mass_marker = .Flap_Mechanism.Rigid_flap.cm  &
   ixx = 29.9283945977  &
   iyy = 5.1007175215  &
   izz = 34.7503519596  &
   ixy = 1.44173341E-002  &
   izx = 0.2094988836  &
   iyz = 9.519489288E-002
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.Rigid_flap.SHL6722  &
   reference_marker = .Flap_Mechanism.Rigid_flap.gra  &
   file_name = "./cad/Rigidflap.shl"  &
   wireframe_only = no
!
part attributes  &
   part_name = .Flap_Mechanism.Rigid_flap  &
   color = GREEN
!
! ****** Graphics from Parasolid file ******
!
file parasolid read  &
   file_name = "flap.xmt_txt"  &
   model_name = .Flap_Mechanism
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.Left_Spoiler.SOLID20  &
   color = SlateBlue  &
   transparency = 40
!
!---------------------------- Higher pair contacts ----------------------------!
!
!
constraint create higher_pair_contact point_curve  &
   point_curve_name = .Flap_Mechanism.inslif_PointCurve  &
   adams_id = 57  &
   i_marker_name = .Flap_Mechanism.inside_slider.ptcv_front  &
   j_floating_marker_name = .Flap_Mechanism.Airframe.Float_inslif_ptcv  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_inslif_ptcv  &
   curve_name = .Flap_Mechanism.CURVE_1
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.inslif_PointCurve  &
   size_of_icons = 0.1
!
constraint create higher_pair_contact point_curve  &
   point_curve_name = .Flap_Mechanism.outf_PointCurve  &
   adams_id = 63  &
   i_marker_name = .Flap_Mechanism.outside_slider.ptcv_front  &
   j_floating_marker_name = .Flap_Mechanism.Airframe.float_outf_ptcv  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_outf_ptcv  &
   curve_name = .Flap_Mechanism.CURVE_56
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.outf_PointCurve  &
   size_of_icons = 0.1
!
constraint create higher_pair_contact point_curve  &
   point_curve_name = .Flap_Mechanism.in_bot_roller_pointcurve  &
   adams_id = 99  &
   i_marker_name = .Flap_Mechanism.inside_bottom_roller.iptcv  &
   j_floating_marker_name =   &
                            .Flap_Mechanism.Airframe.float_in_bot_roller_ptcv  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_in_bot_roller_ptcv  &
   curve_name = .Flap_Mechanism.CURVE_62
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.in_bot_roller_pointcurve  &
   size_of_icons = 0.1
!
constraint create higher_pair_contact point_curve  &
   point_curve_name = .Flap_Mechanism.inslir_PointCurve  &
   adams_id = 101  &
   i_marker_name = .Flap_Mechanism.inside_slider.ptcv_rear  &
   j_floating_marker_name = .Flap_Mechanism.Airframe.float_inslir_ptcv  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_inslir_ptcv  &
   curve_name = .Flap_Mechanism.CURVE_1
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.inslir_PointCurve  &
   size_of_icons = 0.1
!
constraint create higher_pair_contact point_curve  &
   point_curve_name = .Flap_Mechanism.outr_PointCurve  &
   adams_id = 103  &
   i_marker_name = .Flap_Mechanism.outside_slider.ptcv_rear  &
   j_floating_marker_name = .Flap_Mechanism.Airframe.float_outr_ptcv  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_outr_ptcv  &
   curve_name = .Flap_Mechanism.CURVE_56
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.outr_PointCurve  &
   size_of_icons = 0.1
!
constraint create higher_pair_contact point_curve  &
   point_curve_name = .Flap_Mechanism.out_bot_roller_PointCurve  &
   adams_id = 105  &
   i_marker_name = .Flap_Mechanism.outside_bottom_roller.iptcv  &
   j_floating_marker_name =   &
                            .Flap_Mechanism.Airframe.float_out_bot_roller_ptcv  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_out_bot_roller_ptcv  &
   curve_name = .Flap_Mechanism.CURVE_95
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.out_bot_roller_PointCurve  &
   size_of_icons = 0.1
!
!----------------------------------- Joints -----------------------------------!
!
!
constraint create joint cylindrical  &
   joint_name = .Flap_Mechanism.flap_inslider  &
   adams_id = 43  &
   i_marker_name = .Flap_Mechanism.inside_slider.cyl_flap  &
   j_marker_name = .Flap_Mechanism.Rigid_flap.cyl_inslider
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.flap_inslider  &
   size_of_icons = 0.1
!
constraint create joint translational  &
   joint_name = .Flap_Mechanism.flap_in_bot_roller  &
   adams_id = 52  &
   i_marker_name = .Flap_Mechanism.inside_bottom_roller.tr_flap  &
   j_marker_name = .Flap_Mechanism.Rigid_flap.tr_in_bot_rol
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.flap_in_bot_roller  &
   size_of_icons = 0.1
!
constraint create joint universal  &
   joint_name = .Flap_Mechanism.flap_in_eye  &
   adams_id = 137  &
   i_marker_name = .Flap_Mechanism.inside_drive_eye.uni_flap  &
   j_marker_name = .Flap_Mechanism.Rigid_flap.uni_in_eye
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.flap_in_eye  &
   size_of_icons = 0.1
!
constraint create joint fixed  &
   joint_name = .Flap_Mechanism.flap_out_bot_roller  &
   adams_id = 139  &
   i_marker_name = .Flap_Mechanism.outside_bottom_roller.fix_flap  &
   j_marker_name = .Flap_Mechanism.Rigid_flap.fix_out_bot_rol
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.flap_out_bot_roller  &
   size_of_icons = 0.1
!
constraint create joint translational  &
   joint_name = .Flap_Mechanism.out_motor_eye  &
   adams_id = 144  &
   i_marker_name = .Flap_Mechanism.outside_drive_motor.tr_eye  &
   j_marker_name = .Flap_Mechanism.outside_drive_eye.tr_motor
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.out_motor_eye  &
   size_of_icons = 0.1
!
constraint create joint translational  &
   joint_name = .Flap_Mechanism.in_motor_eye  &
   adams_id = 145  &
   i_marker_name = .Flap_Mechanism.inside_drive_motor.tr_eye  &
   j_marker_name = .Flap_Mechanism.inside_drive_eye.tr_motor
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.in_motor_eye  &
   size_of_icons = 0.1
!
constraint create joint spherical  &
   joint_name = .Flap_Mechanism.airframe_in_motor  &
   adams_id = 155  &
   i_marker_name = .Flap_Mechanism.inside_drive_motor.sph_airframe  &
   j_marker_name = .Flap_Mechanism.Airframe.sph_in_motor
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.airframe_in_motor  &
   size_of_icons = 0.1
!
constraint create joint universal  &
   joint_name = .Flap_Mechanism.flap_out_eye  &
   adams_id = 183  &
   i_marker_name = .Flap_Mechanism.outside_drive_eye.uni_flap  &
   j_marker_name = .Flap_Mechanism.Rigid_flap.uni_out_eye
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.flap_out_eye  &
   size_of_icons = 0.1
!
constraint create joint spherical  &
   joint_name = .Flap_Mechanism.airframe_out_motor  &
   adams_id = 186  &
   i_marker_name = .Flap_Mechanism.outside_drive_motor.sph_airframe  &
   j_marker_name = .Flap_Mechanism.Airframe.sph_out_motor
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.airframe_out_motor  &
   size_of_icons = 0.1
!
constraint create joint cylindrical  &
   joint_name = .Flap_Mechanism.flap_outslider  &
   adams_id = 189  &
   i_marker_name = .Flap_Mechanism.outside_slider.cyl_flap  &
   j_marker_name = .Flap_Mechanism.Rigid_flap.cyl_outslider
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.flap_outslider  &
   size_of_icons = 0.1
!
constraint create joint revolute  &
   joint_name = .Flap_Mechanism.Revolute_Spoiler  &
   adams_id = 190  &
   i_marker_name = .Flap_Mechanism.Left_Spoiler.rev_airframe  &
   j_marker_name = .Flap_Mechanism.Airframe.rev_spoiler
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.Revolute_Spoiler  &
   name_visibility = off
!
!----------------------------------- Forces -----------------------------------!
!
!
!-------------------------- Adams/View UDE Instances --------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
undo begin_block suppress = yes
!
ude create instance  &
   instance_name = .Flap_Mechanism.Mot_spoiler  &
   definition_name = .MDI.Constraints.general_motion  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
!-------------------------- Adams/View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.i_marker  &
   object_value = (.Flap_Mechanism.Left_Spoiler.rev_airframe)
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.j_marker  &
   object_value = (.Flap_Mechanism.Airframe.rev_spoiler)
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.constraint  &
   object_value = (.Flap_Mechanism.Revolute_Spoiler)
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t1_type  &
   integer_value = 0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t2_type  &
   integer_value = 0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t3_type  &
   integer_value = 0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r1_type  &
   integer_value = 0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r2_type  &
   integer_value = 0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r3_type  &
   integer_value = 1
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t1_func  &
   string_value = "0 * time"
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t2_func  &
   string_value = "0 * time"
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t3_func  &
   string_value = "0 * time"
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r1_func  &
   string_value = "0 * time"
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r2_func  &
   string_value = "0 * time"
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r3_func  &
   string_value =   &
      "DTOR*(",  &
      "45*STEP5(TIME,5,0,7,1)",  &
      ")"
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t1_ic_disp  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t2_ic_disp  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t3_ic_disp  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r1_ic_disp  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r2_ic_disp  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r3_ic_disp  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t1_ic_velo  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t2_ic_velo  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t3_ic_velo  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r1_ic_velo  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r2_ic_velo  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r3_ic_velo  &
   real_value = 0.0
!
ude modify instance  &
   instance_name = .Flap_Mechanism.Mot_spoiler
!
undo end_block
!
!---------------------------------- Motions -----------------------------------!
!
!
constraint create motion_generator  &
   motion_name = .Flap_Mechanism.MOT_OUT_ACT  &
   adams_id = 158  &
   type_of_freedom = translational  &
   joint_name = .Flap_Mechanism.out_motor_eye  &
   function = ""
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.MOT_OUT_ACT  &
   color = YELLOW  &
   size_of_icons = 0.4
!
constraint create motion_generator  &
   motion_name = .Flap_Mechanism.MOT_IN_ACT  &
   adams_id = 159  &
   type_of_freedom = translational  &
   joint_name = .Flap_Mechanism.in_motor_eye  &
   function = ""
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.MOT_IN_ACT  &
   color = YELLOW  &
   size_of_icons = 0.4
!
!---------------------------------- Accgrav -----------------------------------!
!
!
force create body gravitational  &
   gravity_field_name = ACC  &
   x_component_gravity = 0.0  &
   y_component_gravity = 0.0  &
   z_component_gravity = -9.80665
!
force attributes  &
   force_name = .Flap_Mechanism.ACC  &
   size_of_icons = 0.1
!
!----------------------------- Analysis settings ------------------------------!
!
!
executive_control set numerical_integration_parameters  &
   model_name = Flap_Mechanism  &
   integrator_type = hht  &
   error_tolerance = 1.0E-006  &
   pattern_for_jacobian = no  &
   hinit_time_step = 1.0E-005  &
   corrector = modified
!
output_control set results  &
   model_name = Flap_Mechanism  &
   formatted = on
!
!---------------------------- Function definitions ----------------------------!
!
!
constraint modify motion_generator  &
   motion_name = .Flap_Mechanism.MOT_OUT_ACT  &
   function = "STEP5(TIME,0,0,3,-0.44)"
!
constraint modify motion_generator  &
   motion_name = .Flap_Mechanism.MOT_IN_ACT  &
   function = "STEP5(TIME,0,0,3,-0.44)"
!
!-------------------------- Adams/View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = .Flap_Mechanism.Mot_spoiler
!
!--------------------------- Expression definitions ---------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = Airframe
!
marker modify  &
   marker_name = .Flap_Mechanism.outside_drive_motor.jforce  &
   orientation =   &
      (ORI_ALONG_AXIS(.Flap_Mechanism.outside_drive_motor.jforce, .Flap_Mechanism.outside_drive_eye.iforce, "Z"))  &
   relative_to = .Flap_Mechanism.outside_drive_motor
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
marker modify  &
   marker_name = .Flap_Mechanism.outside_drive_motor.ref  &
   orientation =   &
      (ORI_ALONG_AXIS(.Flap_Mechanism.outside_drive_motor.jforce, .Flap_Mechanism.outside_drive_motor.ref, "Z"))  &
   relative_to = .Flap_Mechanism.outside_drive_motor
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
marker modify  &
   marker_name = .Flap_Mechanism.outside_drive_eye.iforce  &
   orientation =   &
      (ORI_ALONG_AXIS(.Flap_Mechanism.outside_drive_motor.jforce, .Flap_Mechanism.outside_drive_eye.iforce, "Z"))  &
   relative_to = .Flap_Mechanism.outside_drive_eye
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
marker modify  &
   marker_name = .Flap_Mechanism.outside_drive_eye.ref  &
   orientation =   &
      (ORI_ALONG_AXIS(.Flap_Mechanism.outside_drive_motor.jforce, .Flap_Mechanism.outside_drive_eye.ref, "Z"))  &
   relative_to = .Flap_Mechanism.outside_drive_eye
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
marker modify  &
   marker_name = .Flap_Mechanism.inside_drive_motor.jforce  &
   orientation =   &
      (ORI_ALONG_AXIS(.Flap_Mechanism.inside_drive_motor.jforce, .Flap_Mechanism.inside_drive_eye.iforce, "Z"))  &
   relative_to = .Flap_Mechanism.inside_drive_motor
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
marker modify  &
   marker_name = .Flap_Mechanism.inside_drive_motor.ref  &
   orientation =   &
      (ORI_ALONG_AXIS(.Flap_Mechanism.inside_drive_motor.jforce, .Flap_Mechanism.inside_drive_motor.ref, "Z"))  &
   relative_to = .Flap_Mechanism.inside_drive_motor
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
marker modify  &
   marker_name = .Flap_Mechanism.inside_drive_eye.iforce  &
   orientation =   &
      (ORI_ALONG_AXIS(.Flap_Mechanism.inside_drive_motor.jforce, .Flap_Mechanism.inside_drive_eye.iforce, "Z"))  &
   relative_to = .Flap_Mechanism.inside_drive_eye
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
marker modify  &
   marker_name = .Flap_Mechanism.inside_drive_eye.ref  &
   orientation =   &
      (ORI_ALONG_AXIS(.Flap_Mechanism.inside_drive_motor.jforce, .Flap_Mechanism.inside_drive_eye.ref, "Z"))  &
   relative_to = .Flap_Mechanism.inside_drive_eye
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
model display  &
   model_name = Flap_Mechanism
